package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="reqeststatus", schema="hib")
public class RequestStatus {

	public static RequestStatus INITIATED = new RequestStatus(1,"Initiated");
	public static RequestStatus SUBMITTED = new RequestStatus(2,"Submitted");
	public static RequestStatus CHANGE_REQUESTED = new RequestStatus(3,"Change Requested");
	public static RequestStatus APPROVED = new RequestStatus(4,"Approved");
	public static RequestStatus DENIED = new RequestStatus(5,"Denied");
	public static RequestStatus CLOSED = new RequestStatus(6,"Closed");
	public static RequestStatus REQUEST_COMPLETED = new RequestStatus(7, "Request Completed");
	
	
	
	@Id
	@Column(name="id")
	private int id;
	
	@Column(name="name")
	private String name;
	
	private RequestStatus(final int id, final String name) {
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}
	
	public static RequestStatus findById(final int id) throws ObjectNotFoundException {
		switch(id) {
		case 1:
			return INITIATED;
		case 2:
			return SUBMITTED;
		case 3:
			return CHANGE_REQUESTED;
		case 4:
			return APPROVED;
		case 5:
			return DENIED;
		case 6:
			return CLOSED;
		case 7:
			return REQUEST_COMPLETED;
		}
		
		throw new ObjectNotFoundException("Request Status not found with id " + id);
	}
}
